<?php
/*********************************************
STS  - Database Class
Date - 04-Dec-2015 12:00
**********************************************/
class Database {

	private $_hostname = "";
	private $_username = "";
	private $_password = "";
	private $_database = "";
	private $_column = array();

	private $_table = "";
	public $connect = "";
	function __construct(){

		if(define('HOST',"localhost")){
			$this->_hostname = HOST;	
		}
		//sara2374_STS
		if(define('USER','londonfire_staging_lfs_db')){
			$this->_username = USER;	
		}
		//16uK{PoH9fnz
		if(define('PASSWORD',"staging_lfs_db")){
			$this->_password = PASSWORD;
		}
		//sara2374_stanstedtravelservices
		if(define('DATABASE','londonfire_staging_lfs_db')){
			$this->_database = DATABASE;
		}
		

		$this->connect = mysqli_connect($this->_hostname,$this->_username,$this->_password,$this->_database);
		if(!$this->connect)
		die('Enable to connect in MySqL Server.');
	}

	function getTable(){
		return $this->_table;
	}

	function setTable($table){
		if($table != "")$this->_table = $table;
	}

	public function getPaginationData($table){
	}
	public function fetchRowall($table,$cond){

		try{

			if($table != ""){

				$this->_table = $table;
				$query = "SELECT * FROM `".$this->getTable()."` WHERE ".$cond;
				$rs = mysqli_query($this->connect,$query);
				$num = mysqli_num_rows($rs);
				if($num > 0){
					$value = array();
					while($row = mysqli_fetch_array($rs)){

						$value[] = $row;
					}
					return $value;
				}else{
					return $value;
				}
			}else{
				throw new Exception("Please fill the table name.");
			}

		}catch(Exception $e){
			echo $e->getMessage();
		}
	}

	public function fetchRowAllByField($table,$cond,$fields){

		try{

			if($table != ""){

				$this->_table = $table;
				$cnd='';
				if($cond != ''){
				  $cnd=' WHERE '.$cond;
				}

				if(!empty($fields)){
				  $fields = implode(',',$fields);
				}else{
					$fields = "*";
				}

			 	$query = "SELECT ".$fields." FROM `".$this->getTable()."` ".$cnd;
				$rs = mysqli_query($this->connect,$query);
				$num = mysqli_num_rows($rs);
				if($num > 0){
					$value = array();
					while($row = mysqli_fetch_array($rs)){

						$value[] = $row;
					}
					return $value;
				}else{
					return $value;
				}
			}else{
				throw new Exception("Please fill the table name.");
			}

		}catch(Exception $e){
			echo $e->getMessage();
		}
	}

	public function fetchRowAllLimit($table,$cond,$start = 0,$limit = 0){

		try{

			if($table != ""){

				$where = "";
				$limitcond = "";

				if($cond != ""){
					$where = " WHERE ".$cond;
				}

				if($limit > 0){
					$limitcond = " LIMIT ".$start.",".$limit;
				}

				$this->_table = $table;
				$query = "SELECT * FROM `".$this->getTable()."`".$where.$limitcond;
				$rs = mysqli_query($this->connect,$query);
				$num = mysqli_num_rows($rs);
				if($num > 0){
					$value = array();
					while($row = mysqli_fetch_array($rs)){

						$value[] = $row;
					}
					return $value;
				}else{
					return $value;
				}
			}else{
				throw new Exception("Please fill the table name.");
			}

		}catch(Exception $e){
			echo $e->getMessage();
		}
	}

	public function fetchNumOfRow($table,$cond){

		try{
			if($table != ""){

				$where = "";

				if($cond != ""){
					$where = " WHERE ".$cond;
				}

				$this->_table = $table;

				$query = "SELECT * FROM `".$this->getTable()."`".$where;
				$rs = mysqli_query($this->connect,$query);
				$num = mysqli_num_rows($rs);
				if($num > 0){
					return $num;
				}else{
					return NULL;
				}
			}else{
				throw new Exception("Please fill the table name.");
			}

		}catch(Exception $e){
			echo $e->getMessage();
		}
	}

	public function fetchRow($table,$cond){

		try{
			if($table != ""){

				$this->_table = $table;

				$query = "SELECT * FROM `".$this->getTable()."` WHERE ".$cond;
				$rs = mysqli_query($this->connect,$query);
				$num = mysqli_num_rows($rs);
				if($num > 0){
					return mysqli_fetch_array($rs);
				}else{
					return NULL;
				}
			}else{
				throw new Exception("Please fill the table name.");
			}

		}catch(Exception $e){
			echo $e->getMessage();
		}
	}


	public function fetchRowByField($table,$cond,$fields){

		try{
			if($table != ""){

				if(!empty($fields)){
				  $fields = implode(',',$fields);
				}else{
					$fields = "*";
				}

				$this->_table = $table;

				$query = "SELECT ".$fields." FROM `".$this->getTable()."` WHERE ".$cond;
				$rs = mysqli_query($this->connect,$query);
				$num = mysqli_num_rows($rs);
				if($num > 0){
					return mysqli_fetch_array($rs);
				}else{
					return NULL;
				}
			}else{
				throw new Exception("Please fill the table name.");
			}

		}catch(Exception $e){
			echo $e->getMessage();
		}
	}


	public function setData($data){
		$this->_column = $data;
	}

	public function getPageData(){
		return $this->_column;
	}

	public function pagination($table,$cond,$id,$perpageitem=0){
		$adjacents = 3;

		if($table != "")$this->_table = $table;

			if(strlen($cond) > 0){
				$query = "SELECT * FROM `".$this->getTable()."` WHERE ".$cond;
			}else{
				$query = "SELECT * FROM `".$this->getTable()."`";
			}
			$rs = mysqli_query($this->connect,$query);

				$searchCond = $_SERVER['QUERY_STRING'];
				$arr = explode('=',$searchCond);

				if(in_array('pages',$arr)){
					 $searchCond = str_replace(substr($searchCond,0,8),"",$searchCond);
					 if(strlen($searchCond) > 0){
						 $searchCond = '&'.$searchCond;
					 }
				}
			$path = $_SERVER['PHP_SELF'];
			//$file = basename($path,".php");

			$total_pages=mysqli_num_rows($rs);
			$targetpage = $file;
			$limit = $perpageitem;

			$page = (isset($_GET['pages'])) ? $_GET['pages'] : 0;
			if($page)
			$start = ($page - 1) * $limit; 			//first item to display on this page
			else
			$start = 0;
			$limit;
			$limit1=$limit;
			//$data['users'] = $this->admin_model->fechRowAllOrderBylimit('membermaster',$cond,'iMemberID',$start,$limit1);
			if ($page == 0) $page = 1;					//if no page var is given, default to 1.
			$prev = $page - 1;							//Previous page is page - 1
			$Next = $page + 1;							//Next page is page + 1
			$lastpage = ceil($total_pages/$limit);		//lastpage is = total pages / items per page, rounded up.
			$lpm1 = $lastpage - 1;
			$pagination1 = "";
			if($lastpage > 1)
			{
			$pagination1 .= "<div class=\"pagination\"> <div class='alignright'><ul class=\"pagination\">";

			//Previous button
			//pages
			if ($lastpage < 7 + ($adjacents * 2))	//not enough pages to bother breaking it up
			{	for ($counter = 1; $counter <= $lastpage; $counter++)
				{
					if ($counter == $page)
						$pagination1.= "<li class=\"active\"><span>$counter</a></span></li>";
					else
						$pagination1.= "<li><a href=\"$targetpage?pages=$counter$searchCond\">$counter</a></li>";
				}
			}
			elseif($lastpage > 5 + ($adjacents * 2))	//enough pages to hide some
			{ //close to beginning; only hide later pages
				if($page < 1 + ($adjacents * 2))
				{
					for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++)
					{
						if ($counter == $page)
							$pagination1.= "<li class=\"active\"><span>$counter</a></span></li>";
						else
							$pagination1.= "<li><a href=\"$targetpage?pages=$counter$searchCond\">$counter</a></li>";
					}
					$pagination1.= "...";
					$pagination1.= "<li><a href=\"$targetpage?pages=$lpm1$searchCond\">$lpm1</a></li>";
					$pagination1.= "<li><a href=\"$targetpage?pages=$lastpage$searchCond\">$lastpage</a></li>";
				}
				//in middle; hide some front and some back
				elseif($lastpage - ($adjacents * 2) > $page && $page > ($adjacents * 2))
				{
					$pagination1.= "<li><a href=\"$targetpage?pages=1$searchCond\">1</a></li>";
					$pagination1.= "<li><a href=\"$targetpage?pages=2$searchCond\">2</a></li>";
					$pagination1.= "...";
					for ($counter = $page - $adjacents; $counter <= $page + $adjacents; $counter++)
					{
					if ($counter == $page)
					$pagination1.= "<li class=\"active\"><span>$counter</a></span></li>";
					else
					$pagination1.= "<li><a href=\"$targetpage?pages=$counter$searchCond\">$counter</a></li>";
					}
					$pagination1.= "...";
					$pagination1.= "<li><a href=\"$targetpage?pages=$lpm1$searchCond\">$lpm1</a></li>";
					$pagination1.= "<li><a href=\"$targetpage?pages=$lastpage$searchCond\">$lastpage</a></li>";
				}

				//close to end; only hide early pages
				else
				{
				$pagination1.= "<li><a href=\"$targetpage?pages=1$searchCond\">1</a></li>";
				$pagination1.= "<li><a href=\"$targetpage?pages=2$searchCond\">2</a></li>";
				$pagination1.= "...";
				for ($counter = $lastpage - (2 + ($adjacents * 2)); $counter <= $lastpage; $counter++)
				{
				if ($counter == $page)
					$pagination1.= "<li class=\"active\"><span>$counter</a></span></li>";
				else
					$pagination1.= "<li><a href=\"$targetpage?pages=$counter$searchCond\">$counter</a></li>";
					}
				}
			}
			//Next button
			$pagination1.= "</ul></div></div>\n";
			}

			if(strlen($cond) > 0){
				$query = "SELECT * FROM `".$this->getTable()."` WHERE ".$cond." ORDER BY ".$id." DESC LIMIT $start,$limit1";
			}else{
				$query = "SELECT * FROM `".$this->getTable()."` ORDER BY ".$id." DESC LIMIT $start,$limit1";
			}

			$rs = mysqli_query($this->connect,$query);
			$value = array();
				while($row = mysqli_fetch_array($rs)){

					$value[] = $row;
				}
				$this->setData($value);

		return $pagination1;


	}

	function insert($field,$value,$table){

		try{

			for($i=0;$i<count($value); $i++){
				$value[$i] = mysqli_real_escape_string($this->connect,$value[$i]);
			}

			if($table != "")$this->_table = $table;
		 	$query = "INSERT INTO `".$this->getTable()."`(`".implode("`,`",$field)."`) VALUES('".implode("','",$value)."')";

		//echo $query; die;

			$rs = mysqli_query($this->connect,$query);

			if($rs){
				return  mysqli_insert_id($this->connect);
			}else{
				echo mysqli_error($this->connect);
				throw new Exception("Enable to insert data in MySql Server.");
			}

		}catch(Exception $e){
			echo $e->getMessage();
		}
	}

	function update($field,$value,$cond,$table){
		try{

			if($table != "")$this->_table = $table;

			$arrCombine = array_combine($field,$value);
			$query = "UPDATE `".$this->getTable()."` SET ";

			foreach($arrCombine as $key=>$val){
				$query .= $key."='".mysqli_real_escape_string($this->connect,$val)."',";
			}

			$query = rtrim($query,',');
	 		$query .= " WHERE ".$cond;
	 		//echo  $query;exit;
			$rs = mysqli_query($this->connect,$query);
			if($rs){
				return true;
			}else{
				throw new Exception('Enable to update data in MySql Server.');
			}

		}catch(Exception $e){
			echo $e->getMessage();
		}
	}

	function delete($table,$cond){

		try{
			if($table != "")$this->_table = $table;

			$query = "DELETE FROM `".$this->getTable()."` WHERE ".$cond;
			$rs = mysqli_query($this->connect,$query);

			if($rs){
				return true;
			}else{
				throw new Exception("Enable to delete data in MySql Server.");
			}

		}catch(Exception $e){
			echo $e->getMessage();
		}

	}

	function checkValidLogin($table,$cond){
		try{
			if($table != "")$this->_table = $table;

			$query = "SELECT * FROM `".$this->getTable()."` WHERE ".$cond;
			$rs = mysqli_query($this->connect,$query);
			$row = mysqli_fetch_array($rs);

			if(!empty($row)){
				return $row;
			}else{
				return $row;
			}

		}catch(Exception $e){
			echo $e->getMessage();
		}
	}

	public function fetchRowwithjoin($table,$table2,$common,$cond){

		try{
			if($table != ""){

				$this->_table = $table;
				$where="";
				if($cond != ""){
					$where = " WHERE ".$cond;
				}

				$query = "SELECT * FROM `".$this->getTable()."` INNER JOIN `".$this->_database."`.".$table2." ON ".$table.".".$common." = ".$table2.".".$common." ".$where;
				$rs = mysqli_query($this->connect,$query);

				$num = mysqli_num_rows($rs);
				if($num > 0){
					$value = array();
					while($row = mysqli_fetch_assoc($rs)){

						$value[] = $row;
					}
					return $value;
				}else{
					return $value;
				}
			}else{
				throw new Exception("Please fill the table name.");
			}

		}catch(Exception $e){
			echo $e->getMessage();

		}
	}

	public function slugify($field,$value,$cond,$table)
	{

	  $slug = preg_replace("/-$/","",preg_replace('/[^a-z0-9]+/i', "-", strtolower($value)));

	  try{
			if($table != ""){

				if(!empty($field)){
				  $fields = $field;
				}else{
					$fields = "*";
				}

				$this->_table = $table;

				$query = "SELECT COUNT(*) AS NumHits FROM `".$this->getTable()."` WHERE ".$fields." LIKE '$slug%' AND ".$cond;
				$rs = mysqli_query($this->connect,$query);
				$num = mysqli_num_rows($rs);
				if($num > 0){
					$r = mysqli_fetch_array($rs);
					$numHits = $r['NumHits'];
					return ($numHits > 0) ? ($slug . '-' . $numHits) : $slug;
				}else{
					return $slug;
				}
			}else{
				throw new Exception("Please fill the table name.");
			}

		}catch(Exception $e){
			echo $e->getMessage();
		}

	}
	public function customeQuery($query)
	{
		//echo $query;
		//die();
		try{
			if($query != ""){
				$rs = mysqli_query($this->connect,$query);
				//echo $query;
				//var_dump($rs);
				//die();
				$num = mysqli_num_rows($rs);
				if($num > 0){
					$value = array();
					while($row = mysqli_fetch_assoc($rs)){

						$value[] = $row;
					}
					return $value;
				}else{
					return $value;
				}
			}else{
				throw new Exception("Please fill the table name.");
			}

		}catch(Exception $e){
			echo $e->getMessage();

		}
	}
	public function runSelect($query)
	{
		//echo $query;
		//die();
		try{
			if($query != ""){
				$rs = mysqli_query($this->connect,$query);
				$num = mysqli_num_rows($rs);
				if($num > 0){
					$value = array();
					while($row = mysqli_fetch_assoc($rs)){

						$value[] = $row;
					}
					return $value;
				}else{
					return $value;
				}
			}else{
				throw new Exception("Please fill the table name.");
			}

		}catch(Exception $e){
			echo $e->getMessage();

		}
	}
}

function send_mail($to,$subject,$message,$from){
	require("class.phpmailer.php");
	
		
	$to = $to;
	$from = $from;
	//$from = "php@nyusoft.in";
	
	$mail = new PHPMailer();
	$mail->IsSMTP();
	$mail->Host = "portal.londonfiresolutions.co.uk";
	//$mail->Host = "smtp.office365.com";
	$mail->SMTPDebug = 1;
	$mail->SMTPAuth = false;
	
	$mail->Username = "noreply@portal.londonfiresolutions.co.uk";
	$mail->Password = "Nan@123dos";
	/*$mail->Username = "noreply@londonfiresolutions.co.uk";
	$mail->Password = "Fire@2018";*/
	
	/*$mail->Port = "465";*/
	$mail->Port = 25;
	$mail->SMTPSecure = "tls"; // ssl and tls
	$mail->From = "noreply@portal.londonfiresolutions.co.uk";
	//$mail->From = $from;
	$mail->FromName ="LFS Portal";
	$mail->AddAddress($to);
	$mail->AddReplyTo($to);
	//$mail->WordWrap = 50;    // set word wrap to 50 characters
	$mail->IsHTML(true);
	$mail->Subject = $subject;
	$mail->Body    = $message; 
	if(!$mail->Send())
	{
	  echo "Error sending: ";
	}
	else
	{
	  // echo "E-mail sent";
	}
}

// function  doorinstallation_notification_email($door_installation_name,$projectjobNo,$attachement1,$attachement2,$emailsubject,$retmsg,$templatedata,$surveyordatao_email,$admin_email,$additionalemails);
// {

// 	$chanegstr = array("%lfsjobnumber%"=>$projectjobNo,"%doornoname%" =>$door_installation_name);
// 	$mailcontent =$templatedata['e_Body'];
// 	$subject = strtr($emailsubject,$chanegstr);
// 	$to = $admin_email;

// 	$message = $mailcontent;        
// 	$from = "noreply@londonfiresolutions.co.uk";


//      // $sentmail = send_mail($to,$subject,$message,$from);

// if (!class_exists('PHPMailer'))
// {
//   require("class.phpmailer.php");
// }

//       $to = $to;

// 	$from = $from;
// 	//$from = "php@nyusoft.in";
	
// 	$mail = new PHPMailer();
// 	$mail->IsSMTP();
// 	$mail->Host = "portal.londonfiresolutions.co.uk";
// 	//$mail->Host = "smtp.office365.com";
// 	$mail->SMTPDebug = 1;
// 	$mail->SMTPAuth = false;
	
// 	$mail->Username = "noreply@portal.londonfiresolutions.co.uk";
// 	$mail->Password = "Nan@123dos";
// 	/*$mail->Username = "noreply@londonfiresolutions.co.uk";
// 	$mail->Password = "Fire@2018";*/
	
// 	/*$mail->Port = "465";*/
// 	$mail->Port = 25;
// 	$mail->SMTPSecure = "tls"; // ssl and tls
// 	$mail->From = "noreply@portal.londonfiresolutions.co.uk";
// 	//$mail->From = $from;
// 	if ($additionalemails) {
// 		foreach ($additionalemails as $keyvalue) {
// 			$mail->addCC($keyvalue);
// 		}
// 	}
// 	if ($surveyordatao_email) {
// 	$mail->addCC($surveyordatao_email);
// 	}

// 	$mail->FromName ="LFS Portal";
// 	$mail->AddAddress($to);
// 	$mail->AddReplyTo($to);
// 	//$mail->WordWrap = 50;    // set word wrap to 50 characters
// 	//$mail->addAttachment($attachement1);         // Add attachments
// 	//$mail->addAttachment($attachement2);    // Optional name

// 	$mail->IsHTML(true);
// 	$mail->Subject = $subject;
// 	$mail->Body    = $message; 
	
// 	if(!$mail->Send())
// 	{
// 	   //echo "2";
// 	}
// 	else
// 	{
// 	  //echo "1";
// 	}

// }
