var applaunchCount = window.localStorage.getItem('launchCount');

$(document).ready(function (){
    document.addEventListener("deviceready", onDeviceReady, false);
    console.log("Index Ready");
});

function onDeviceReady()
{
    checkConnection();
}

function checkConnection()
{
    var networkState = navigator.connection.type;
    var states = {};
    states[Connection.UNKNOWN] = 'Unknown connection';
    states[Connection.ETHERNET] = 'Ethernet connection';
    states[Connection.WIFI] = 'WiFi connection';
    states[Connection.CELL_2G] = 'Cell 2G connection';
    states[Connection.CELL_3G] = 'Cell 3G connection';
    states[Connection.CELL_4G] = 'Cell 4G connection';
    states[Connection.CELL] = 'Cell generic connection';
    states[Connection.NONE] = 'No network connection';

    if (states[networkState] == "No network connection")
    {
        window.location.href = "dashboard.html";
    }
    else
    {
        if (applaunchCount)
        {
            window.location.href = "dashboard.html";
        }
        else
        {
            SQLiteLFSDatabase();
            window.localStorage.setItem('launchCount', 1);
        }
    }
}

function SQLiteLFSDatabase()
{
    cordova.plugin.pDialog.init({
        theme: 'HOLO_DARK',
        progressStyle: 'SPINNER',
        cancelable: false,
        title: 'Please Wait...',
        message: 'Contacting server ...'
    });

    $.ajax({
        url: urlis+"surveyorlist",
        type: "POST",
        crossDomain: true,
        dataType: "json",
        data: "{}",
        success: function (data)
        {
            if(JSON.stringify(data) != "")
            {
                cordova.plugin.pDialog.setMessage('Live data load....');
                var db = window.openDatabase("LFSDatabase", "1.0", "LFSDatabase", 200000);
                console.log("DB Created Successfully !");
                db.transaction(loginDataBase, errorCB, function () {
                });
                function loginDataBase(tx) {
                    tx.executeSql('DROP TABLE IF EXISTS lfs_surveyor');
                    tx.executeSql('CREATE TABLE IF NOT EXISTS lfs_surveyor (surveyor_ID, s_Slug,s_FirstName,s_LastName,s_Email,surveyType_ID,qMarkInstaller,createdBy,updatedBy,createdDate,updatedDate,isActive,isDelete)');
                    for (var i = 0; i < data.length; i++) {
                    console.log(JSON.stringify(data[i]));
                        tx.executeSql("INSERT INTO lfs_surveyor (surveyor_ID, s_Slug,s_FirstName,s_LastName,s_Email,surveyType_ID,qMarkInstaller,createdBy,updatedBy,createdDate,updatedDate,isActive,isDelete) VALUES ('"+data[i].surveyor_ID+"', '"+data[i].s_Slug+"','"+data[i].s_FirstName+"','"+data[i].s_LastName+"','"+data[i].s_Email+"','"+data[i].surveyType_ID+"','"+data[i].qMarkInstaller+"','"+data[i].createdBy+"','"+data[i].updatedBy+"','"+data[i].createdDate+"','"+data[i].updatedDate+"','"+data[i].isActive+"','"+data[i].isDelete+"')");
                    }
                    create_clients_table();
                }
            }
        },
        error: function (response) {
            alert("Error In Response :- "+response);
        }
    });
}

function create_clients_table()
{
    $.ajax({
            url: urlis+"client_list",
            type: "POST",
            crossDomain: true,
            dataType: "json",
            data: "{}",
            success: function (data)
            {
                if(JSON.stringify(data) != "")
                {
                    var db = window.openDatabase("LFSDatabase", "1.0", "LFSDatabase", 200000);
                    console.log("DB Created Successfully !");
                    db.transaction(loginDataBase, errorCB, function () {
                    });
                    function loginDataBase(tx) {
                        tx.executeSql('DROP TABLE IF EXISTS lfs_clients');
                        tx.executeSql('CREATE TABLE IF NOT EXISTS lfs_clients(client_ID, c_Slug,c_Name,c_Email,createdBy,updatedBy,createdDate,updatedDate,isActive,isDelete)');
                        for (var i = 0; i < data.length; i++) {
                        console.log("Client Data :- " + JSON.stringify(data[i]));
                            tx.executeSql("INSERT INTO lfs_clients (client_ID, c_Slug,c_Name,c_Email,createdBy,updatedBy,createdDate,updatedDate,isActive,isDelete) VALUES ('"+data[i].client_ID+"','"+data[i].c_Slug+"','"+data[i].c_Name+"','"+data[i].c_Email+"','"+data[i].createdBy+"','"+data[i].updatedBy+"','"+data[i].createdDate+"','"+data[i].updatedDate+"','"+data[i].isActive+"','"+data[i].isDelete+"')");
                        }
                        create_survey_type_table();
                    }
                }
            },
            error: function (response) {
                alert("Error In Response :- "+response);
            }
        });
}

function create_survey_type_table()
{
    $.ajax({
        url: urlis+"client_list",
        type: "POST",
        crossDomain: true,
        dataType: "json",
        data: "{}",
        success: function (data)
        {
            if(JSON.stringify(data) != "")
            {
                var db = window.openDatabase("LFSDatabase", "1.0", "LFSDatabase", 200000);
                console.log("DB Created Successfully !");
                db.transaction(loginDataBase, errorCB, function () {
                });
                function loginDataBase(tx) {
                    tx.executeSql('DROP TABLE IF EXISTS lfs_survey_type');
                    tx.executeSql('CREATE TABLE IF NOT EXISTS lfs_survey_type(surveyType_ID,s_Type,createdBy,updatedBy,createdDate,updatedDate,isActive,isDelete)');
                    for (var i = 0; i < data.length; i++) {
                    console.log("Client Data :- " + JSON.stringify(data[i]));
                        tx.executeSql("INSERT INTO lfs_survey_type (surveyType_ID,s_Type,createdBy,updatedBy,createdDate,updatedDate,isActive,isDelete) VALUES ('"+data[i].surveyType_ID+"','"+data[i].s_Type+"','"+data[i].createdBy+"','"+data[i].updatedBy+"','"+data[i].createdDate+"','"+data[i].updatedDate+"','"+data[i].isActive+"','"+data[i].isDelete+"')");
                    }
                    create_project_table();
                }
            }
        },
        error: function (response) {
            alert("Error In Response :- "+response);
        }
    });
}

function create_project_table()
{
    $.ajax({
        url: urlis+"client_list",
            type: "POST",
            crossDomain: true,
            dataType: "json",
            data: "{}",
            success: function (data)
            {
                if(JSON.stringify(data) != "")
                {
                    var db = window.openDatabase("LFSDatabase", "1.0", "LFSDatabase", 200000);
                    console.log("DB Created Successfully !");
                    db.transaction(loginDataBase, errorCB, function () {
                     });
                    function loginDataBase(tx) {
                        tx.executeSql('DROP TABLE IF EXISTS lfs_projects');
                         tx.executeSql('CREATE TABLE IF NOT EXISTS lfs_projects(project_ID,client_ID,p_Name,contract_Address,building_Type,costruction_Of_Building,no_Of_Floor,isGroundFloor,isBasement,building_Height,no_Of_Staircases,main_Contractor,p_Date,p_Images,poNo,responsiblePerson,jobNo,isStarted,isCompleted,createdBy,updatedBy,createdDate,updatedDate,isActive,isDelete)');
                        for (var i = 0; i < data.length; i++) {
                            console.log("Client Data :- " + JSON.stringify(data[i]));
                            tx.executeSql("INSERT INTO lfs_projects (project_ID,client_ID,p_Name,contract_Address,building_Type,costruction_Of_Building,no_Of_Floor,isGroundFloor,isBasement,building_Height,no_Of_Staircases,main_Contractor,p_Date,p_Images,poNo,responsiblePerson,jobNo,isStarted,isCompleted,createdBy,updatedBy,createdDate,updatedDate,isActive,isDelete) VALUES ('"+data[i].project_ID+"','"+data[i].client_ID+"','"+data[i].p_Name+"','"+data[i].contract_Address+"','"+data[i].building_Type+"','"+data[i].costruction_Of_Building+"','"+data[i].no_Of_Floor+"','"+data[i].isGroundFloor+"','"+data[i].isBasement+"','"+data[i].building_Height+"','"+data[i].no_Of_Staircases+"','"+data[i].main_Contractor+"','"+data[i].p_Date+"','"+data[i].p_Images+"','"+data[i].poNo+"','"+data[i].responsiblePerson+"','"+data[i].jobNo+"','"+data[i].isStarted+"','"+data[i].isCompleted+"','"+data[i].createdBy+"','"+data[i].updatedBy+"','"+data[i].createdDate+"','"+data[i].updatedDate+"','"+data[i].isActive+"','"+data[i].isDelete+"')");
                        }
                        create_assign_survey_table();
                    }
                }
           },
           error: function (response) {
               alert("Error In Response :- "+response);
           }
    });
}

function create_assign_survey_table()
{
    $.ajax({
        url: urlis+"client_list",
           type: "POST",
           crossDomain: true,
           dataType: "json",
           data: "{}",
           success: function (data)
           {
               if(JSON.stringify(data) != "")
               {
                   var db = window.openDatabase("LFSDatabase", "1.0", "LFSDatabase", 200000);
                   console.log("DB Created Successfully !");
                   db.transaction(loginDataBase, errorCB, function () {
                   });
                   function loginDataBase(tx) {
                       tx.executeSql('DROP TABLE IF EXISTS lfs_asign_survey');
                       tx.executeSql('CREATE TABLE IF NOT EXISTS lfs_asign_survey(asign_ID,surveyor_ID,surveyType_ID,project_ID,createdBy,updatedBy,createdDate,updatedDate,isActive,isDelete)');
                       for (var i = 0; i < data.length; i++) {
                       console.log("Client Data :- " + JSON.stringify(data[i]));
                           tx.executeSql("INSERT INTO lfs_asign_survey (asign_ID,surveyor_ID,surveyType_ID,project_ID,createdBy,updatedBy,createdDate,updatedDate,isActive,isDelete) VALUES ('"+data[i].asign_ID+"','"+data[i].surveyor_ID+"','"+data[i].surveyType_ID+"','"+data[i].project_ID+"','"+data[i].createdBy+"','"+data[i].updatedBy+"','"+data[i].createdDate+"','"+data[i].updatedDate+"','"+data[i].isActive+"','"+data[i].isDelete+"')");
                       }
                       cordova.plugin.pDialog.dismiss();
                       window.location.href = "dashboard.html";
                   }
               }
           },
           error: function (response) {
               alert("Error In Response :- "+response);
           }
    });
}